import { Repository } from 'typeorm';
import { Product } from '../../entities/product.entity';
import { Category } from '../../entities/category.entity';
import { Vendor } from '../../entities/vendor.entity';
import { CreateProductDto } from './dto/create-product.dto';
import { UpdateProductDto } from './dto/update-product.dto';
import { ProductResponseDto } from './dto/product-response.dto';
import { ProductQueryDto } from './dto/product-query.dto';
export declare class ProductsService {
    private readonly productRepo;
    private readonly categoryRepo;
    private readonly vendorRepo;
    constructor(productRepo: Repository<Product>, categoryRepo: Repository<Category>, vendorRepo: Repository<Vendor>);
    private toProductResponseDto;
    create(createProductDto: CreateProductDto, vendorId?: string): Promise<ProductResponseDto>;
    findAll(query: ProductQueryDto): Promise<{
        products: ProductResponseDto[];
        total: number;
        page: number;
        limit: number;
        totalPages: number;
    }>;
    findOne(id: number): Promise<ProductResponseDto>;
    findByIds(ids: number[]): Promise<ProductResponseDto[]>;
    update(id: number, updateProductDto: UpdateProductDto, vendorId?: string): Promise<ProductResponseDto>;
    remove(id: number, vendorId?: string): Promise<void>;
    updateStock(id: number, quantity: number, operation?: 'increase' | 'decrease'): Promise<ProductResponseDto>;
    toggleFeatured(id: number): Promise<ProductResponseDto>;
    getFeaturedProducts(limit?: number): Promise<ProductResponseDto[]>;
    getProductsByCategory(categoryId: number, query: ProductQueryDto): Promise<{
        products: ProductResponseDto[];
        total: number;
        page: number;
        limit: number;
        totalPages: number;
    }>;
    getProductsByVendor(vendorId: string, query: ProductQueryDto): Promise<{
        products: ProductResponseDto[];
        total: number;
        page: number;
        limit: number;
        totalPages: number;
    }>;
    searchProducts(searchTerm: string, limit?: number): Promise<ProductResponseDto[]>;
    getLowStockProducts(threshold?: number): Promise<ProductResponseDto[]>;
    getProductStats(): Promise<{
        totalProducts: number;
        totalInStock: number;
        totalOutOfStock: number;
        featuredProducts: number;
        categoryStats: any[];
        vendorStats: any[];
    }>;
}
